
beta2 = 0.58:0.02:0.7;
repe = 20;
s_error = zeros(length(beta2),repe);
r_error = zeros(length(beta2),repe);
nonconvex_error = zeros(length(beta2),repe);
r_score_runtime = zeros( length(beta2), repe);
nonconvex_runtime = zeros( length(beta2), repe);
results = zeros(length(beta2), 6);
results(:, 1) = beta2';
for j = 1:length(beta2)
    rng(66);
    for i = 1:repe
        fprintf('%s\n', repmat('-', 1, 50));
        fprintf('beta2: %f; %i th repetition\n',beta2(j), i);
        [A, k, true_label, Pi, P, theta] = generate_network(30, 0.01, 2, 0.1, beta2(j));
        try
            % R-SCORE
            tic;
            score_label = SCORE_update(A, k);
            [score_error, ~] = recovery_error(true_label, score_label);
            [r_score_error, ~] = R_SCORE(A, k, score_label, 3, P, true_label, theta);
            r_score_runtime(j,i) = toc;
            s_error(j,i) = score_error;
            r_error(j,i) = r_score_error;
        catch ME
            % Handle the error: set errors to -1
            fprintf('Error occurred: %s\n', ME.message);
            s_error(j, i) = -1;
            r_error(j, i) = -1;
            r_score_runtime(j, i) = NaN; % Optionally set runtime to NaN
        end

        % nonconvex
        tic;
        [Z0, alpha0, ~] = init_SVT(A, k);
        [Z, alpha] = nonconvex(A, Z0, alpha0, 800);  % Adjust nonconvex parameters if needed
        nonconvex_error(j,i) = clustering_error_Z(Z, true_label);
        nonconvex_runtime(j,i) = toc;
    end
end

results(:, 2) = mean(s_error(:,1:5),2); % score error
results(:, 3) = mean(r_error(:,1:5),2); % R-score error
results(:, 4) = mean(r_score_runtime(:,1:5),2); % R-score runtime
results(:, 5) = mean(nonconvex_error(:,1:5),2); % nonconvex error
results(:, 6) = mean(nonconvex_runtime(:,1:5),2); % nonconvex runtime
s_error_final = mean(s_error,2);
nonconvex_error_final = mean(nonconvex_error,2);
r_score_time_final = mean(r_score_runtime, 2);
nonconvex_time_final = mean(nonconvex_runtime, 2);
% 
% % Convert results to a table for better visualization
% results_table = array2table(results, 'VariableNames', {'beta2', 'SCORE_Error', 'R_SCORE_Error','R_SCORE_Runtime', 'Nonconvex_Error', 'Nonconvex_Runtime'});
% 
% % Display results in MATLAB
% disp(results_table);




%% Plot

v_beta2 = 0.58:0.02:0.7;
y_rscore = s_error_final;
y_nonconvex = nonconvex_error_final;

figure;
% Plot the first line in red with circle markers
plot(v_beta2, y_rscore, '-o', 'LineWidth', 4, 'MarkerSize', 6, 'Color', 'r', 'MarkerFaceColor', 'r')

% Hold on to overlay the second plot
hold on 

% Plot the second line in blue with square markers
plot(v_beta2, y_nonconvex, '-s', 'LineWidth', 4, 'MarkerSize', 6, 'Color', 'b', 'MarkerFaceColor', 'b')

% Customize the axes
xlabel('\beta_2', 'FontSize', 12) % Label for the x-axis
ylabel('Error rate', 'FontSize', 12) % Label for the y-axis
%title('Comparison of Scores', 'FontSize', 14) % Add a title

% Add a legend
legend({'R-SCORE', 'npMLE'}, 'FontSize', 15, 'Location', 'southwest')

% Add grid for clarity
%grid on

% Adjust axis limits (optional, if you want)
xlim([min(v_beta2) max(v_beta2)]) % Set x-axis limits
ylim([min([r_score_y; nonconvex_score_y])-0.005 max([r_score_y; nonconvex_score_y])+0.01]) % Set y-axis limits


